$(document).ready(function() {

    $(document).on('click','#repeat_search',function(){
        var $obj = $('#swith-1');
        setTimeout(function(){
            $('#repeat-swith-1').val(($($obj).hasClass('checked')) ? 1 : 0);
            change_repeat_button($($obj).hasClass('checked'));
        },100);
    })

    $(document).on('click','#auto_delete',function(){
        var $obj = $('#swith-2');
        setTimeout(function(){
            $('#repeat-swith-2').val(($($obj).hasClass('checked')) ? 1 : 0);
            change_delete_button($($obj).hasClass('checked'));
        },100);
    })

    $(document).on('click','a.repeat_frequency',function(event){
        event.preventDefault();

        if(global_frequency_type != $(this).attr('data-id')){
            global_frequency_type = $(this).attr('data-id');
            $('li.repeat_frequency').removeClass('active');
            $('li.repeat_frequency[data-id="'+global_frequency_type+'"]').addClass('active');
            $('span.repeat_frequency').text($(this).text());
            change_repeat_options();
        }
    })

    $(document).on('click','a.delete_options',function(event){
        event.preventDefault();

        if(global_delete_type != $(this).attr('data-id')){
            global_delete_type = $(this).attr('data-id');
            $('li.delete_options').removeClass('active');
            $('li.delete_options[data-id="'+global_delete_type+'"]').addClass('active');
            $('span.delete_options').text($(this).text());
            change_delete_options();
        }
    })

    $(document).on('click','.weekdays_btn',function(){
        $(this).toggleClass('btn-success');
    })

    $(document).on('click','#next_step5',function(event){
        event.preventDefault();
        var datefrom        = $('[name="datefrom"]').val();
        var timefrom        = $('[name="timefrom"]').val();
        var is_repeat       = $('#repeat-swith-1').val();
        var auto_delete     = $('#repeat-swith-2').val();
        var untildate       = $('[name="untildate"]').val();
        var untiltime       = $('[name="untiltime"]').val();
        var deletedate      = $('[name="deletedate"]').val();
        var deletetime      = $('[name="deletetime"]').val();
        var repeat_delay    = $('[name="repeat_delay"]').val();
        var delete_delay    = $('[name="delete_delay"]').val();
        var repeat_type     = global_frequency_type;
        var delete_type     = global_delete_type;

        var weekdays = [];

        $('.weekdays_btn.btn-success').each(function(){
            weekdays.push($(this).attr('data-id'));
        })

        $.ajax({
            url: 'ajax.php',
            dataType: 'json',
            type: 'POST',
            data: {action_function: 'next_step5', datefrom: datefrom, timefrom: timefrom, is_repeat: is_repeat, auto_delete: auto_delete,
                    untildate: untildate, untiltime: untiltime, deletedate: deletedate, deletetime: deletetime,
                    repeat_delay: repeat_delay, delete_delay: delete_delay, repeat_type: repeat_type, weekdays: weekdays, delete_type:delete_type
            },
            'beforeSend' : function(){ show_ajax();},
            //'complete' : function() { hide_ajax();},
            'success': function (data) {

                if (data.status == 1) {
                    window.location.href = data.url;
                };

                if (data.status == 2) {
                    hide_ajax();
                    $('.errors_block').html('<div class="alert alert-info alert-danger"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'+data.message+'</div>');
                };

            },
            'error': function () {
                console.log('error');
            }
        })
    })
})

function change_repeat_button(show)
{
    if(show){
        change_repeat_options();
    }else{
        $('.is_repeat').fadeOut('slow');
    }
}

function change_delete_button(show)
{
    if(show){
        change_delete_options();
    }else{
        $('.is_delete').fadeOut('slow');
    }
}

function change_delete_options()
{
    $('div#delete_options').fadeIn('slow');
    if(global_delete_type == 1){
        $('div#delete_date').fadeOut('slow');
        $('div#delete_after').fadeIn('slow');
    }else{
        $('div#delete_after').fadeOut('slow');
        $('div#delete_date').fadeIn('slow');
    }
}

function change_repeat_options()
{
    $('div#repeat_until').fadeIn('slow');
    $('div#repeat_options').fadeIn('slow');
    if(global_frequency_type == 4){
        $('div#repeat_delay').fadeIn('slow');
    }else{
        $('div#repeat_delay').fadeOut('slow');
    }

    if(global_frequency_type == 2){
        $('div#repeat_weekdays').fadeIn('slow');
    }else{
        $('div#repeat_weekdays').fadeOut('slow');
    }
}